<?php

/**
 * Display Header with Navbar
 *
 * @package Valio Theme
 * @subpackage Valio Theme
 * @since Valio Theme 1.0
 */
?>

<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Quicksand:wght@300..700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=DM+Serif+Text:ital@0;1&family=Quicksand:wght@300..700&display=swap" rel="stylesheet">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

    <header>
        <div class="site-header">

            <!-- Logo -->
            <?php if (the_custom_logo()) : ?>
                <div class="sh-site-logo"><?php the_custom_logo(); ?></div>
            <?php endif ?>

            <!-- Navbar -->
            <nav class="sh-site-navigation" class="main-navigation">
                <?php
                if (has_nav_menu('main-menu')) :
                    wp_nav_menu(
                        array(
                            'theme_location' => 'main-menu',
                            'menu_class'     => 'main-menu',
                            'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                        )
                    );
                endif;
                ?>
                <a href="mailto:contact@pui-valiotech.com" class="nav-contact">Nous contacter</a>
            </nav>
        </div>
    </header>